<?php

define('FIR', true);

// Database Settings
define('DB_TYPE', getenv('DB_TYPE'));
define('DB_HOST', getenv('DB_HOST'));
define('DB_USERNAME', getenv('DB_USERNAME'));
define('DB_DATABASE', getenv('DB_DATABASE'));
define('DB_PASSWORD', getenv('DB_PASSWORD'));
define('DB_PREFIX', '');
define('DB_CHARSET', 'utf8mb4');
define('DB_COLLATION', 'utf8mb4_unicode_ci');

// External Paths
define('URL_PATH', getenv('URL_PATH'));

// Internal Paths
define('PUBLIC_PATH', 'public');
define('THEME_PATH', 'themes');
define('STORAGE_PATH', 'storage');
define('UPLOADS_PATH', 'uploads');

// Miscellaneous
define('COOKIE_PATH', preg_replace('|https?://[^/]+|i', '', URL_PATH) . '/');

// Config Variables

$GLOBALS['config'] = array(
  'remember' => array(
    'cookie_name' => 'hash',
    'cookie_expiry' => 604800
  ),
  'session' => array(
    'session_admin' => 'votingAdmin',
    'session_name' => 'votingUser',
    'token_name' => 'token'
  )
);


// Category
define('CATEGORY', getenv('CATEGORY_CAPITAL_LETTERS'));
define('CATEGORY_URL', getenv('CATEGORY_SMALL_LETTERS'));
define('CATEGORIES', getenv('CATEGORY_CAPITAL_LETTERS_PLURAL'));
define('CATEGORIES_URL', getenv('CATEGORY_SMALL_LETTERS_PLURAL'));

// Client User Roles
define('CANDIDATE', getenv('CANDIDATE_CAPITAL_LETTERS'));
define('CANDIDATE_URL', getenv('CANDIDATE_SMALL_LETTERS'));
define('CANDIDATES', getenv('CANDIDATE_CAPITAL_LETTERS_PLURAL'));
define('CANDIDATES_URL', getenv('CANDIDATE_SMALL_LETTERS_PLURAL'));
